package jadean.ui.handlers;

import java.util.ArrayList;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;

public class HandlerUtilities {
	public static String[] getNatureIds(Object element) {
		IProject project = null;
		IProjectDescription description;
		String[] natureIDs;
		if (element instanceof IProjectNature) {
			IProjectNature nature = (IProjectNature) element;
			project = nature.getProject();
		}
		else if (element instanceof IProject) {
			project = (IProject) element;
		}
		if (project != null) {
			try {
				description = project.getDescription();
				natureIDs = description.getNatureIds();
				return natureIDs;
			}
			catch (Exception e) {
				return null;
			}
		}
		return null;
	}
	
	public static String[] getSupportedNatureIds(String[] natureIds) {
		ArrayList<String> ret = new ArrayList<String>();
		DependencyAnalyzerHandlersFactory handlersFactory = DependencyAnalyzerHandlersFactory.getInstance();
		
		for (String natureID: natureIds) {
			if (handlersFactory.isSupportedNature(natureID)) {
				ret.add(natureID);
			}
		}
		
		return ret.toArray(new String[ret.size()]);
	}
}
